const adminAuth = (req, res, next) => {
  // Simple session check - in production use proper authentication
  if (req.session && req.session.adminLoggedIn) {
    return next();
  }

  // Check if it's the login page or auth endpoint
  if (req.path === '/login' || req.path === '/auth') {
    return next();
  }

  // Redirect to login if not authenticated
  res.redirect('/admin/login');
};

module.exports = adminAuth;