document.addEventListener('DOMContentLoaded', function() {
  // Mobile sidebar toggle
  const sidebarToggle = document.getElementById('sidebar-toggle');
  const sidebarOverlay = document.getElementById('sidebar-overlay');
  const sidebarClose = document.getElementById('sidebar-close');

  if (sidebarToggle && sidebarOverlay) {
    sidebarToggle.addEventListener('click', function() {
      sidebarOverlay.classList.remove('hidden');
    });
  }

  if (sidebarClose && sidebarOverlay) {
    sidebarClose.addEventListener('click', function() {
      sidebarOverlay.classList.add('hidden');
    });
  }

  // Close sidebar when clicking overlay
  if (sidebarOverlay) {
    sidebarOverlay.addEventListener('click', function(e) {
      if (e.target === sidebarOverlay) {
        sidebarOverlay.classList.add('hidden');
      }
    });
  }

  // Close sidebar on window resize
  window.addEventListener('resize', function() {
    if (window.innerWidth >= 768 && sidebarOverlay) {
      sidebarOverlay.classList.add('hidden');
    }
  });

  // Auto-hide notifications
  const notifications = document.querySelectorAll('.notification');
  notifications.forEach(notification => {
    setTimeout(() => {
      notification.style.opacity = '0';
      setTimeout(() => {
        notification.remove();
      }, 300);
    }, 5000);
  });
});