document.addEventListener('DOMContentLoaded', function() {
  const contactForm = document.querySelector('form');

  if (contactForm) {
    contactForm.addEventListener('submit', function(e) {
      e.preventDefault();

      const formData = new FormData(this);
      const data = Object.fromEntries(formData);

      if (validateForm(data)) {
        simulateFormSubmission(data);
      }
    });
  }

  function validateForm(data) {
    if (!data.name || data.name.trim().length < 2) {
      showAlert('لطفاً نام خود را به درستی وارد کنید.', 'error');
      return false;
    }

    if (!data.email || !isValidEmail(data.email)) {
      showAlert('لطفاً ایمیل معتبری وارد کنید.', 'error');
      return false;
    }

    if (!data.subject) {
      showAlert('لطفاً موضوع پیام را انتخاب کنید.', 'error');
      return false;
    }

    if (!data.message || data.message.trim().length < 10) {
      showAlert('پیام شما باید حداقل ۱۰ کاراکتر باشد.', 'error');
      return false;
    }

    return true;
  }

  function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
  }

  function simulateFormSubmission(data) {
    const submitButton = contactForm.querySelector('button[type="submit"]');
    const originalText = submitButton.innerHTML;

    submitButton.innerHTML = '<iconify-icon icon="solar:refresh-bold" class="animate-spin ml-2"></iconify-icon>در حال ارسال...';
    submitButton.disabled = true;

    setTimeout(() => {
      showAlert('پیام شما با موفقیت ارسال شد. در اسرع وقت با شما تماس خواهیم گرفت.', 'success');
      contactForm.reset();

      submitButton.innerHTML = originalText;
      submitButton.disabled = false;
    }, 2000);
  }

  function showAlert(message, type = 'info') {
    const alertDiv = document.createElement('div');
    alertDiv.className = `fixed top-4 left-1/2 transform -translate-x-1/2 z-50 px-6 py-4 rounded-lg shadow-lg transition-all duration-300 ${
      type === 'success' ? 'bg-green-500 text-white' :
      type === 'error' ? 'bg-red-500 text-white' :
      'bg-blue-500 text-white'
    }`;

    alertDiv.innerHTML = `
      <div class="flex items-center space-x-2 space-x-reverse">
        <iconify-icon icon="${
          type === 'success' ? 'solar:check-circle-bold' :
          type === 'error' ? 'solar:close-circle-bold' :
          'solar:info-circle-bold'
        }" class="text-xl"></iconify-icon>
        <span>${message}</span>
      </div>
    `;

    document.body.appendChild(alertDiv);

    setTimeout(() => {
      alertDiv.style.opacity = '0';
      alertDiv.style.transform = 'translate(-50%, -100%)';
      setTimeout(() => {
        document.body.removeChild(alertDiv);
      }, 300);
    }, 5000);
  }

  const socialLinks = document.querySelectorAll('a[href="#"]');
  socialLinks.forEach(link => {
    link.addEventListener('click', function(e) {
      e.preventDefault();
      const platform = this.querySelector('span').textContent;
      showAlert(`صفحه ${platform} در دسترس نیست.`, 'info');
    });
  });
});