document.addEventListener('DOMContentLoaded', function() {
  // Articles Swiper
  const articlesSwiper = new Swiper('#articles-swiper', {
    direction: 'horizontal',
    loop: true,
    autoplay: {
      delay: 4000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    pagination: {
      el: '#articles-swiper .swiper-pagination',
      clickable: true,
    },
    navigation: false,
    effect: 'slide',
    speed: 600,
    spaceBetween: 16,
    slidesPerView: 1.5,
    grabCursor: true,
    touchRatio: 1,
    touchAngle: 45,
    breakpoints: {
      768: {
        slidesPerView: 2.5,
        spaceBetween: 20,
      },
    },
  });

  // News Swiper
  const newsSwiper = new Swiper('#news-swiper', {
    direction: 'horizontal',
    loop: true,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    pagination: {
      el: '#news-swiper .swiper-pagination',
      clickable: true,
    },
    navigation: false,
    effect: 'slide',
    speed: 600,
    spaceBetween: 16,
    slidesPerView: 1.5,
    grabCursor: true,
    touchRatio: 1,
    touchAngle: 45,
    breakpoints: {
      768: {
        slidesPerView: 2.5,
        spaceBetween: 20,
      },
    },
  });

  // Resume autoplay after interaction
  const swipers = [articlesSwiper, newsSwiper];

  swipers.forEach(swiper => {
    // Resume autoplay after click interaction
    swiper.on('click', () => {
      setTimeout(() => {
        if (swiper.autoplay.paused) {
          swiper.autoplay.start();
        }
      }, 3000);
    });

    // Resume autoplay after touch interaction
    swiper.on('touchEnd', () => {
      setTimeout(() => {
        if (swiper.autoplay.paused) {
          swiper.autoplay.start();
        }
      }, 3000);
    });
  });
});