const express = require('express');
const router = express.Router();

// Admin Root - redirect to dashboard if logged in, login if not
router.get('/', (req, res) => {
  if (req.session && req.session.adminLoggedIn) {
    res.redirect('/admin/dashboard');
  } else {
    res.redirect('/admin/login');
  }
});

// Admin Login Page
router.get('/login', (req, res) => {
  res.render('admin/login', {
    title: 'ورود مدیریت',
    error: req.query.error
  });
});

// Admin Authentication
router.post('/auth', (req, res) => {
  const { username, password } = req.body;

  // Simple authentication - in production use proper password hashing
  if (username === 'admin' && password === 'admin123') {
    req.session.adminLoggedIn = true;
    res.redirect('/admin/dashboard');
  } else {
    res.redirect('/admin/login?error=1');
  }
});

// Admin Dashboard
router.get('/dashboard', (req, res) => {
  res.render('admin/dashboard', {
    title: 'داشبورد مدیریت',
    currentPage: 'dashboard'
  });
});

// Users Management
router.get('/users', (req, res) => {
  res.render('admin/users', {
    title: 'مدیریت کاربران',
    currentPage: 'users'
  });
});

// Content Management
router.get('/content', (req, res) => {
  res.render('admin/content', {
    title: 'مدیریت محتوای سایت',
    currentPage: 'content'
  });
});

// Trading Signals Management
router.get('/signals', (req, res) => {
  res.render('admin/signals', {
    title: 'مدیریت سیگنال‌های تریدینگ',
    currentPage: 'signals'
  });
});

// Add Signal Page
router.get('/signals/add', (req, res) => {
  res.render('admin/signals-add', {
    title: 'افزودن محتوای جدید',
    currentPage: 'signals'
  });
});

// Edit Signal Page
router.get('/signals/edit/:id', (req, res) => {
  const contentId = req.params.id;
  res.render('admin/signals-edit', {
    title: 'ویرایش محتوا',
    currentPage: 'signals',
    contentId: contentId
  });
});

// Add Signal POST
router.post('/signals/add', (req, res) => {
  const { action } = req.body;
  // In a real app, save the content to database
  // For now, just redirect back to signals page
  if (action === 'publish') {
    // Save as published
    res.redirect('/admin/signals?success=published');
  } else {
    // Save as draft
    res.redirect('/admin/signals?success=draft');
  }
});

// Edit Signal POST
router.post('/signals/edit', (req, res) => {
  const { action, contentId } = req.body;
  // In a real app, update the content in database
  // For now, just redirect back to signals page
  if (action === 'update') {
    res.redirect('/admin/signals?success=updated');
  } else {
    res.redirect('/admin/signals?success=draft');
  }
});

// Delete Signal
router.delete('/signals/delete/:id', (req, res) => {
  const contentId = req.params.id;
  // In a real app, delete the content from database
  res.json({ success: true, message: 'محتوا با موفقیت حذف شد' });
});

// Settings
router.get('/settings', (req, res) => {
  res.render('admin/settings', {
    title: 'تنظیمات',
    currentPage: 'settings'
  });
});

// Logout
router.post('/logout', (req, res) => {
  req.session.destroy();
  res.redirect('/admin/login');
});

module.exports = router;