const axios = require('axios');
const cheerio = require('cheerio');

async function testGoldScraping() {
  try {
    console.log('Fetching gold prices from: https://alanchand.com/gold-price');

    const response = await axios.get('https://alanchand.com/gold-price', {
      headers: {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
      }
    });

    const $ = cheerio.load(response.data);

    console.log('=== Page title ===');
    console.log($('title').text());

    console.log('\n=== Looking for all tables ===');
    $('table').each((i, table) => {
      console.log(`\nTable ${i + 1}:`);
      console.log('Class:', $(table).attr('class'));
      console.log('ID:', $(table).attr('id'));

      $(table).find('tr').slice(0, 5).each((j, row) => {
        const cells = [];
        $(row).find('td, th').each((k, cell) => {
          cells.push($(cell).text().trim());
        });
        if (cells.length > 0) {
          console.log(`Row ${j + 1}:`, cells);
        }
      });
    });

    console.log('\n=== Looking for divs with gold-related classes ===');
    $('div[class*="gold"], div[class*="price"], div[class*="table"]').each((i, div) => {
      console.log(`Div ${i + 1}: class="${$(div).attr('class')}", text="${$(div).text().trim().substring(0, 100)}"`);
    });

    console.log('\n=== Looking for elements containing gold prices ===');
    $('*').each((i, element) => {
      const text = $(element).text().trim();
      if (text.includes('طلا') || text.includes('سکه') || text.includes('انس')) {
        if (text.length < 200) {
          console.log(`Element ${i}: ${$(element).prop('tagName')} - "${text}"`);
        }
      }
    });

  } catch (error) {
    console.error('Error:', error.message);
  }
}

testGoldScraping();